use score ;

CREATE TABLE practices
	id int NOT NULL AUTO_INCREMENT, 
	practicesgroup varchar(255) NOT NULL, 
	title text NOT NULL, 
	duration varchar(255) NOT NULL, 
	views int NOT NULL, 
	likes int NOT NULL, 
	createdAt datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), 
	shortDescription text NOT NULL, longDescription text NOT NULL, 
	status enum('save', 'publish') NOT NULL DEFAULT 'save', 
	language enum('FR', 'EN', 'ES', 'LT') NOT NULL DEFAULT 'EN') ;

CREATE TABLE practices_Domains
	practices_id int NOT NULL, 
	domain_id int NOT NULL, INDEX IDX_xxxxxxxxxxxxxxxxxxxxxxx(buildingBlocks_id), INDEX IDX_xxxxxxxxxxxxxxxxxxxxxxx(domain_id), 
	PRIMARY KEY(buildingBlocks_id, domain_id)); 


CREATE TABLE practices_Hashtags
	practices_id int NOT NULL, 
	hashtags_id int NOT NULL, INDEX IDX_xxxxxxxxxxxxxxxxxxxxxxx(buildingBlocks_id), INDEX IDX_xxxxxxxxxxxxxxxxxxxxxxx(hashtags_id), 
	PRIMARY KEY(buildingBlocks_id, hashtags_id)); 


CREATE TABLE practices_Steps
	practices_id int NOT NULL,
	step enum('Set-up', 'Raise awareness', 'Explore practice and sytems', 'Make and prototype', 'Reflet', 'Share') NOT NULL DEFAULT 'Set-up')
	buildingBlockId int NOT NULL,
	order int NOT NULL,
	

